//
//  AHKABArrayController_Dragging.m
//  AH-K3001V Utilities
//
//  Created by FUJIDANA on Fri Apr 16 2005.
//  Copyright (c) 2005 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//

#import "AHKABArrayController.h"
#import "AHKPerson.h"
#import "AHKABMainWindowController.h"

@interface NSIndexSet (AHKABArrayControllerAdditions)

+ (NSIndexSet *)indexSetFromArray:(NSArray *)array;
- (unsigned int)numberOfIndexesLessThanIndex:(unsigned int)index;

@end

#pragma mark -

@implementation NSIndexSet (AHKABArrayControllerAdditions)

// Original method is indexSetFromRows:
+ (NSIndexSet *)indexSetFromArray:(NSArray *)array
{
	NSMutableIndexSet *indexSet = [NSMutableIndexSet indexSet];
	NSEnumerator *enumerator = [array objectEnumerator];
	NSNumber *idx;
	while (idx = [enumerator nextObject]) {
		[indexSet addIndex:[idx intValue]];
	}
	return indexSet;
}

// Original method is rowsAboveRows:inIndexSet:.
// But this selecor name is confusing, because this method returns number of "smaller" rows than first argument (row).
- (unsigned int)numberOfIndexesLessThanIndex:(unsigned int)index
{
	unsigned currentIndex = [self firstIndex];
	int i = 0;
	while (currentIndex != NSNotFound) {
		if (currentIndex < index) {
			i++;
		}
		currentIndex = [self indexGreaterThanIndex:currentIndex];
	}
	return i;
}

@end

#pragma mark -

@interface AHKABArrayController (Dragging_Private)
- (void)moveObjectsInArrangedObjectsFromIndexes:(NSIndexSet *)indexSet toIndex:(unsigned)index;
@end

#pragma mark -

@implementation AHKABArrayController (Dragging)

// --- register table view as dragging dragging destitnation.
- (void)registerTableViewForDraggedTypes
{
	NSArray *array = [[NSArray arrayWithObject:AHKABRowIndexesPboardType] arrayByAddingObjectsFromArray:[mainWindowController acceptablePasteboardTypes]];
	[contentTableView registerForDraggedTypes:array];
}

#pragma mark implementation of NSTableDataSource (Dragging)

// --- Method for dragging source. Deprecated in Mac OS X v10.4 and later.
// --- - (BOOL)tableView:(NSTableView *)tv writeRowsWithIndexes:(NSIndexSet *)rowIndexes toPasteboard:(NSPasteboard*)pboard
// --- is recommended, but this does not run on Mac OS X v10.3.
- (BOOL)tableView:(NSTableView *)tableView writeRows:(NSArray *)rows toPasteboard:(NSPasteboard *)pboard
{
	NSIndexSet	*rowIndexes	= [NSIndexSet indexSetFromArray:rows];
	
	return [mainWindowController writePeopleAtIndexes:rowIndexes
										 toPasteboard:pboard 
												types:[mainWindowController distributablePasteboardTypes]];
}

// --- Method for dragging destiation. Validate whether dropped items are acceptable or not.
- (NSDragOperation)tableView:(NSTableView *)tableView validateDrop:(id <NSDraggingInfo>)info proposedRow:(int)row proposedDropOperation:(NSTableViewDropOperation)operation
{
	NSDragOperation dragOperation = [info draggingSourceOperationMask];
	
//	NSLog([[[info draggingPasteboard] types] description]);
//	return NSDragOperationNone;
	
	// if the drag source is not in the same application as the destination, ...
	if ([info draggingSource] == nil) {
		dragOperation = NSDragOperationCopy & dragOperation;
	
	// if the drag source is self, only moving and copying is supported (default is moving).
	} else if ([info draggingSource] == tableView) {
		if (dragOperation & NSDragOperationMove || dragOperation & NSDragOperationGeneric) {
			// allow move only when the data source are not filtered or sorted.
			if ([self searchString] && [[self searchString] isEqualToString:@""] == NO ||
				[self sortDescriptors] && [[self sortDescriptors] isEqualToArray:[NSArray array]] == NO) {
				
				dragOperation = NSDragOperationNone;
			} else {
				dragOperation = NSDragOperationMove;
			}
		} else if (dragOperation & NSDragOperationCopy) {
			dragOperation = NSDragOperationCopy;
		} else {
			dragOperation = NSDragOperationNone;
		}
	}
	// we want to put the object at, not over, the current row (contrast NSTableViewDropOn) 
	[tableView setDropRow:row dropOperation:NSTableViewDropAbove];
	
	return dragOperation;
}

//  --- Method for dragging destination. Invoked when dragging object is dropped on the table view and passed the validation written above.
- (BOOL)tableView:(NSTableView *)tableView acceptDrop:(id <NSDraggingInfo>)info row:(int)row dropOperation:(NSTableViewDropOperation)operation
{
	if (row < 0) {
		row = 0;
	}
	
	// If the dragging source is the same table view as dragging distination, only moving is allowed.
	if ([info draggingSource] == tableView && [info draggingSourceOperationMask] != NSDragOperationCopy) {
		if ([[[info draggingPasteboard] types] containsObject:AHKABRowIndexesPboardType]) {
//			NSArray		*rows		= [[info draggingPasteboard] propertyListForType:AHKABRowIndexesPboardType];
//			NSIndexSet	*rowIndexes	= [self indexSetFromRows:rows];
			
			NSData		*data		= [[info draggingPasteboard] dataForType:AHKABRowIndexesPboardType];
			NSIndexSet	*rowIndexes	= [NSKeyedUnarchiver unarchiveObjectWithData:data];
			
			if (rowIndexes && [rowIndexes isKindOfClass:[NSIndexSet class]]) {
				[self moveObjectsInArrangedObjectsFromIndexes:rowIndexes toIndex:row];
				
				// set selected rows to those that were moved now
				// To determine proper selection, we need to work out what is moved to where ...
				int numberOfIndexesLessThanRow = [rowIndexes numberOfIndexesLessThanIndex:row];
				
				NSRange		range			= NSMakeRange(row - numberOfIndexesLessThanRow, [rowIndexes count]);
				NSIndexSet	*newRowIndexes	= [NSIndexSet indexSetWithIndexesInRange:range];
				[self setSelectionIndexes:newRowIndexes];
				
				return YES;
			}
		}
		return NO;
	} else {
		return [mainWindowController insertPeopleFromPasteboard:[info draggingPasteboard] atRow:row];
	}
}

// --- Works only on Mac OS X 10.4 and later. 
// --- Because this is data source method of NSTableView, this method is simply not invoked in Mac OS X 10.3.
- (NSArray *)tableView:(NSTableView *)tv namesOfPromisedFilesDroppedAtDestination:(NSURL *)dropDestination forDraggedRowsWithIndexes:(NSIndexSet *)indexSet
{
	NSMutableArray	*filenames		= [NSMutableArray arrayWithCapacity:[indexSet count]];
	
	NSArray			*droppedPeople	= [[self arrangedObjects] objectsAtIndexes:indexSet];
	AHKPerson		*person;
	NSEnumerator	*enumerator		= [droppedPeople objectEnumerator];
	
	while (person = [enumerator nextObject]) {
		NSString	*lastPath;
		if ([person name]) {
			lastPath = [NSString stringWithFormat:@"%03d_%@.vcf", [person number], [person name]];
		} else {
			lastPath = [NSString stringWithFormat:@"%03d_Unnamed.vcf", [person number]];
		}
		NSString *escapedLastPath = [lastPath stringByAddingPercentEscapesUsingEncoding:NSUTF8StringEncoding];
		NSURL	*droppedFileURL	= [NSURL URLWithString:escapedLastPath 
										 relativeToURL:dropDestination];
		if (droppedFileURL == nil) {
		}
		if ([[person vCardRepresentation] writeToURL:droppedFileURL atomically:YES]) {
			[filenames addObject:lastPath];
		}
	}
	return filenames;
}

#pragma mark private auxiliary methods

// --- 
-(void)moveObjectsInArrangedObjectsFromIndexes:(NSIndexSet *)indexSet toIndex:(unsigned)index
{
//	NSUndoManager *undo = [[mainWindowController window] undoManager];
//	[[undo prepareWithInvocationTarget:self] restoreArrangementAndSelection];
	
	unsigned off1 = 0, off2 = 0;
    
	unsigned currentIndex = [indexSet firstIndex];
	while (currentIndex != NSNotFound) {
		unsigned i = currentIndex;
		
		if (i < index) {
			i -= off1++;
			[self insertObject:[[self arrangedObjects] objectAtIndex:i] atArrangedObjectIndex:index];
			[self removeObjectAtArrangedObjectIndex:i];
		} else {
			[self insertObject:[[self arrangedObjects] objectAtIndex:i] atArrangedObjectIndex:index+off2++];
			[self removeObjectAtArrangedObjectIndex:i+1];
		}
		currentIndex = [indexSet indexGreaterThanIndex:currentIndex];
	}
//	[self restoreArrangementAndSelection];
}

@end


// The licence of the source code above is as following:

/*
 Copyright (c) 2004, Apple Computer, Inc., all rights reserved.
 
 IMPORTANT:  This Apple software is supplied to you by Apple Computer, Inc. ("Apple") in
 consideration of your agreement to the following terms, and your use, installation, 
 modification or redistribution of this Apple software constitutes acceptance of these 
 terms.  If you do not agree with these terms, please do not use, install, modify or 
 redistribute this Apple software.
 
 In consideration of your agreement to abide by the following terms, and subject to these 
 terms, Apple grants you a personal, non-exclusive license, under Apple’s copyrights in 
 this original Apple software (the "Apple Software"), to use, reproduce, modify and 
 redistribute the Apple Software, with or without modifications, in source and/or binary 
 forms; provided that if you redistribute the Apple Software in its entirety and without 
 modifications, you must retain this notice and the following text and disclaimers in all 
 such redistributions of the Apple Software.  Neither the name, trademarks, service marks 
 or logos of Apple Computer, Inc. may be used to endorse or promote products derived from 
 the Apple Software without specific prior written permission from Apple. Except as expressly
 stated in this notice, no other rights or licenses, express or implied, are granted by Apple
 herein, including but not limited to any patent rights that may be infringed by your 
 derivative works or by other works in which the Apple Software may be incorporated.
 
 The Apple Software is provided by Apple on an "AS IS" basis.  APPLE MAKES NO WARRANTIES, 
 EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, 
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPLE SOFTWARE OR ITS 
 USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL 
 DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
		  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, 
 REPRODUCTION, MODIFICATION AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND 
 WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR 
 OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
